<?php 
include('siteconfig.php');

error_reporting(0);
ini_set('display_errors', 0);

ini_set('user_agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.9) Gecko/20071025 Firefox/2.0.0.9');

function cano($s){
	$s = $output = trim(preg_replace(array("`'`", "`[^a-z0-9]+`"),  array("", "-"), strtolower($s)), "-");
	return $s;
}
$link = $_GET['link'];
$link = explode("/", $link);


$link_id = $link[0];
$data = file_get_contents('https://www.giantbomb.com/api/game/'.$link_id.'/?api_key='.$giantbomb_key.'&format=json');
$response = json_decode($data);


$game_title = $response->results->name;
$game_intro = $response->results->deck;
$game_desc = $response->results->description;
$game_desc_clean = preg_replace('/href="([^"]*)"/', ' ', $game_desc);


?>
<!doctype html>
<html>
    <head>
      <meta charset="utf-8"/>
	  <meta name="viewport" content="width=device-width">
	  <title><?php echo $game_title;?> - <?php echo $videogamepage_title;?> - <?php echo $site_title;?></title>
      <meta name="description" content="<?php echo $game_title;?> <?php echo $videogamepage_title;?> - <?php echo $game_intro;?>" />
      <meta name="keywords" content="<?php echo $game_title;?>, <?php echo $site_keywords;?>" />
	  <meta property="og:site_name" content="<?php echo $site_title; ?>"/>
	  <meta property="og:locale" content="en_US"/>
      <meta property="og:type" content="website"/>
      <meta property="og:title" content="<?php echo $game_title;?> - <?php echo $videogamepage_title;?> - <?php echo $site_title;?>"/>
      <meta property="og:description" content="<?php echo $game_title;?> <?php echo $videogamepage_title;?> - <?php echo $game_intro;?>"/>
	  <?php if(isset($response->results->image->small_url) and !empty($response->results->image->small_url)): ?>
	  <meta property="og:image" content="<?php echo $response->results->image->small_url;?>">
	  <?php endif; ?>
	  <link href="<?php echo $site_url;?>/style.css" rel="stylesheet" type="text/css">
      <link href='https://fonts.googleapis.com/css?family=Open+Sans:400,700' rel='stylesheet' type='text/css'>
      <link href="<?php echo $site_url;?>/favicon.ico" rel="shortcut icon" type="image/x-icon">
	  <link type="text/css" rel="stylesheet" href="<?php echo $site_url;?>/dist/css/lightgallery.css" />
	  <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
	  <?php include 'ads/head_code.php'; ?>
	  
    </head>
<body>

<?php include 'includes/header.php'; ?>
<div class="box-gamecontent">
<div class="postheader"
<?php if(isset($response->results->images) and !empty($response->results->images)): ?> 
style="background-image:url(<?php echo $response->results->images[0]->super_url;?>);"
<?php endif; ?>
>
<div class="overlay">
<div class="wrap">
<div class="gameposttitle">
<h1><?php echo $game_title;?></h1>
</div>
<div class="gamepostintro">
<?php echo $game_intro;?>
</div>
<?php if(isset($response->results->platforms) and !empty($response->results->platforms)): ?>
<div class="introplatforms">
<?php 
foreach ($response->results->platforms as $platforms)
	{
		if(file_exists("images/platforms20/w$platforms->name.png"))
		$fileName = "w$platforms->name";
		else
		$fileName = "defaultplatform";
		echo '<a href="'.$site_url.'/platform/'.$platforms->id.'/'.cano($platforms->name).'/" ><img src="'.$site_url.'/images/platforms20/'.$fileName.'.png" alt=" ">'.$platforms->name.'</a> ';
	}
?>
</div>
<?php endif; ?>
</div>
</div>
</div>
<div class="after-header"></div>
<div class="wrap">
<div class="gametabs">
	<ul id="myTab" class="nav nav-tabs">
                    <li class="active"><a href="#summary" data-toggle="tab">Summary</a></li>
					<?php if(isset($response->results->images) and !empty($response->results->images)): ?>  
                    <li><a href="#images" data-toggle="tab">Images</a></li>
					<?php endif; ?>
					<?php if(isset($response->results->videos) and !empty($response->results->videos)): ?>   
					<li><a href="#videos" data-toggle="tab">Videos</a></li>
                    <?php endif; ?>
					<?php if(isset($response->results->reviews) and !empty($response->results->reviews)): ?> 
					<li><a href="#reviews" data-toggle="tab">Reviews</a></li>
					<?php endif; ?>
					<?php if(isset($response->results->similar_games) and !empty($response->results->similar_games)): ?> 
					<li><a href="#similar" data-toggle="tab">Similar Games</a></li>
					<?php endif; ?>
					<li><a href="#comments" data-toggle="tab">Comments</a></li>
	</ul>
</div>

<!-- begin tab-content -->
<div id="movieTab" class="tab-content">
<!-- summary Tab -->
<div class="tab-pane fade active in" id="summary">
<div class="postcontent">
<div style="margin:0px 0px 10px 0px;">
<?php include 'ads/singlepage_ad_728x90.php'; ?>
</div>
<div class="videoinfo">
<div class="videodesc">
<p><?php echo $game_desc_clean;?></p>
</div>
</div>
</div>
</div>
<!-- end Info Tab -->
<!-- images tab -->
<div class="tab-pane fade" id="images">
<div class="postcontent">
<div>
<ul id="lightgallery">
                 <?php 
foreach ($response->results->images as $image)
	{
		echo '<li data-src="'.$image->super_url.'"><a href=""><img class="thumbnail" src="'.$image->medium_url.'" ><span class="overlay"><i class="icon-camera"></i></span></a></li>';
	}
?>       </ul>
          </div>
		  
                </div>
            </div>
<!-- end images tab-->
<!-- videos tab -->
<div class="tab-pane fade" id="videos">
	<div class="postcontent">
            <div>
				
                 <?php 
foreach ($response->results->videos as $video)
	{
		echo '<i class="icon-play"></i> <a href="'.$site_url.'/video/'.$video->id.'/'.cano($video->name).'/">'.$video->name.'</a></br>';
	}
?>      
          </div>    
   </div>
</div>
<!-- end videos tab-->
<!-- reviews tab -->
            <div class="tab-pane fade" id="reviews">
             <div class="postcontent">
<?php if(isset($response->results->reviews) and !empty($response->results->reviews)): ?>                   
<?php 
foreach ($response->results->reviews as $reviews)
	{
		echo '<i class="icon-star"></i> <a href="'.$site_url.'/review/'.$reviews->id.'/'.cano($reviews->name).'/">'.$reviews->name.'</a></br>';
	}
?>  
<?php endif; ?>
 </div>
            </div>
<!-- end reviews tab-->
<!-- similar tab -->
            <div class="tab-pane fade" id="similar">
             <div class="postcontent">
<?php if(isset($response->results->similar_games) and !empty($response->results->similar_games)): ?>    
                 <?php 
foreach ($response->results->similar_games as $similar)
	{
		echo '<i class="icon-gamepad"></i> <a href="'.$site_url.'/game/'.$similar->id.'/'.cano($similar->name).'/">'.$similar->name.'</a></br>';
	}
?>      
<?php endif; ?> 
 </div>
            </div>
<!-- end similar tab-->
<!-- comments tab -->
            <div class="tab-pane fade" id="comments">
             <div class="postcontent">
<?php if(isset($disqus_shortname) and !empty($disqus_shortname)): ?>
<div class="videocomments">
<div id="disqus_thread"></div>
<script type="text/javascript">
    /* * * CONFIGURATION VARIABLES * * */
    var disqus_shortname = '<?php echo $disqus_shortname;?>';
    
    /* * * DON'T EDIT BELOW THIS LINE * * */
    (function() {
        var dsq = document.createElement('script'); dsq.type = 'text/javascript'; dsq.async = true;
        dsq.src = '//' + disqus_shortname + '.disqus.com/embed.js';
        (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(dsq);
    })();
</script>
<noscript>Please enable JavaScript to view the <a href="https://disqus.com/?ref_noscript" rel="nofollow">comments powered by Disqus.</a></noscript>
</div>
<?php endif; ?>
                </div>
            </div>
<!-- end comments tab-->
</div>
<!-- end all tabs-->
<!-- .post-sidebar -->
<div class="post-sidebar">
<div class="post-sidebar-box">
<?php if(isset($response->results->image->small_url) and !empty($response->results->image->small_url)): ?>
<img class="game-img" src="<?=$response->results->image->small_url?>" alt="<?php echo $game_title;?>" itemprop="image" width="300px">
<?php endif; ?>
<h3>Game Details</h3>
<span class="arrow_down"></span>
<div class="inner">
<b>Name</b></br><?php echo $game_title;?></br>
<?php if(isset($response->results->original_release_date) and !empty($response->results->original_release_date)): ?> 
<b>Release Date </b></br><?php echo substr($response->results->original_release_date,0,10);?> </br>
<?php endif; ?>
<?php if(isset($response->results->genres) and !empty($response->results->genres)): ?> 
<b>Genre</b></br><?php 
foreach ($response->results->genres as $genre)
	{
		echo $genre->name.'</br>';
	}
?>
<?php endif; ?>
<?php if(isset($response->results->themes) and !empty($response->results->themes)): ?>
<b>Theme</b></br><?php 
foreach ($response->results->themes as $themes)
	{
		echo $themes->name.'</br>';
	}
?>
<?php endif; ?>
<?php if(isset($response->results->developers) and !empty($response->results->developers)): ?>
<b>Developer</b></br> <?php 
foreach ($response->results->developers as $developers)
	{
		echo $developers->name.'</br>';
	}
?>
<?php endif; ?>
<?php if(isset($response->results->publishers[0]->name) and !empty($response->results->publishers[0]->name)): ?>
<b>Publisher</b></br><?php echo $response->results->publishers[0]->name;?></br>
<?php endif; ?>
<?php if(isset($response->results->platforms) and !empty($response->results->platforms)): ?>
<b>Platform</b></br><?php 
foreach ($response->results->platforms as $platforms)
	{
		echo '<a href="'.$site_url.'/platform/'.$platforms->id.'/'.cano($platforms->name).'/" >'.$platforms->name.'</a></br>';
	}
?>
<?php endif; ?>
<b>Share This</b></br>
<div style="margin-top:5px;">
<div class="addthis_toolbox addthis_default_style addthis_32x32_style">
<a class="addthis_button_preferred_1"></a>
<a class="addthis_button_preferred_2"></a>
<a class="addthis_button_preferred_3"></a>
<a class="addthis_button_preferred_4"></a>
<a class="addthis_button_preferred_5"></a>
<a class="addthis_button_preferred_6"></a>
<a class="addthis_button_compact"></a>
</div>
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=<?php echo $addthis_id; ?>"></script>
</div>

<?php if(isset($amazon_id) and !empty($amazon_id)): ?>
<b>Buy Now</b></br>
<a class="affbut" href="http://www.amazon.com/gp/search?ie=UTF8&camp=1789&creative=9325&index=videogames&keywords=<?php echo $game_title;?>&linkCode=ur2&tag=<?php echo $amazon_id;?>" target="_blank" rel="nofollow">Buy on Amazon</a>
<?php endif; ?>
</div>
</div>
<div style="margin:10px 0px 10px 0px;">
<?php include 'ads/sidebar_ad_300x250.php'; ?>
</div>
</div>
<!-- end .post-sidebar -->
<script>
function init() {
var imgDefer = document.getElementsByTagName('img');
for (var i=0; i<imgDefer.length; i++) {
if(imgDefer[i].getAttribute('data-src')) {
imgDefer[i].setAttribute('src',imgDefer[i].getAttribute('data-src'));
} } }
window.onload = init;
</script>
<script type="text/javascript">
        $(document).ready(function(){
            $('#lightgallery').lightGallery();
        });
        </script>
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jqueryui/1.8.23/jquery-ui.min.js"></script>
<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/swfobject/2.2/swfobject.js"></script>
<script type="text/javascript" src="<?php echo $site_url;?>/js/bootstrap.min.js"></script>
   
<script src="<?php echo $site_url;?>/dist/js/lightgallery.js"></script>
<script src="<?php echo $site_url;?>/dist/js/lg-fullscreen.js"></script>
<script src="<?php echo $site_url;?>/dist/js/lg-thumbnail.js"></script>
<script src="<?php echo $site_url;?>/dist/js/lg-video.js"></script>
<script src="<?php echo $site_url;?>/dist/js/lg-autoplay.js"></script>
<script src="<?php echo $site_url;?>/dist/js/lg-zoom.js"></script>
<script src="<?php echo $site_url;?>/dist/js/lg-hash.js"></script>
<script src="<?php echo $site_url;?>/dist/js/lg-pager.js"></script>
</div>
</div>
<?php include "includes/footer.php"; ?>
</body>
</html>